/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world.biomes;

import java.util.Random;
import net.minecraft.class_1308;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.registry.NetherBlocks;
import paulevs.betternether.registry.NetherEntities;
import paulevs.betternether.registry.NetherFeatures;
import paulevs.betternether.world.NetherBiome;
import paulevs.betternether.world.NetherBiomeConfig;
import paulevs.betternether.world.structures.StructureType;
import paulevs.betternether.world.structures.plants.StructureBlackBush;
import paulevs.betternether.world.structures.plants.StructureNetherWart;
import paulevs.betternether.world.structures.plants.StructureWartSeed;
import ru.bclib.api.biomes.BCLBiomeBuilder;
import ru.bclib.world.biomes.BCLBiomeSettings;

public class NetherWartForestEdge
extends NetherBiome {
    public NetherWartForestEdge(class_2960 biomeID, class_1959 biome, BCLBiomeSettings settings) {
        super(biomeID, biome, settings);
    }

    @Override
    protected void onInit() {
        this.addStructure("nether_wart", new StructureNetherWart(), StructureType.FLOOR, 0.02f, false);
        this.addStructure("wart_seed", new StructureWartSeed(), StructureType.FLOOR, 0.01f, false);
        this.addStructure("black_bush", new StructureBlackBush(), StructureType.FLOOR, 0.01f, false);
    }

    @Override
    public void genSurfColumn(class_1936 world, class_2338 pos, Random random) {
        switch (random.nextInt(3)) {
            case 0: {
                super.genSurfColumn(world, pos, random);
                break;
            }
            case 1: {
                BlocksHelper.setWithoutUpdate(world, pos, class_2246.field_10114.method_9564());
                break;
            }
            case 2: {
                BlocksHelper.setWithoutUpdate(world, pos, class_2246.field_22090.method_9564());
                break;
            }
            case 3: {
                BlocksHelper.setWithoutUpdate(world, pos, NetherBlocks.NETHERRACK_MOSS.method_9564());
            }
        }
        for (int i = 1; i < random.nextInt(3); ++i) {
            class_2338 down = pos.method_10087(i);
            if (random.nextInt(3) != 0 || !BlocksHelper.isNetherGround(world.method_8320(down))) continue;
            BlocksHelper.setWithoutUpdate(world, down, class_2246.field_10114.method_9564());
        }
    }

    public static class Config
    extends NetherBiomeConfig {
        public Config(String name) {
            super(name);
        }

        @Override
        protected void addCustomBuildData(BCLBiomeBuilder builder) {
            builder.fogColor(191, 28, 28).loop(class_3417.field_22452).additions(class_3417.field_22451).mood(class_3417.field_22453).music(class_3417.field_23796).feature(NetherFeatures.NETHER_RUBY_ORE);
        }

        @Override
        public BCLBiomeBuilder.BiomeSupplier<NetherBiome> getSupplier() {
            return NetherWartForestEdge::new;
        }

        @Override
        public <M extends class_1308> int spawnWeight(NetherEntities.KnownSpawnTypes type) {
            int res = super.spawnWeight(type);
            switch (type) {
                case FLYING_PIG: {
                    res = type.weight;
                    break;
                }
                case NAGA: {
                    res = 0;
                }
            }
            return res;
        }
    }
}

